<?php
require_once dirname(__DIR__) . '/config/db.php';

try {
    // Get admin role ID
    $stmt = $pdo->prepare("SELECT id FROM roles WHERE name = 'Admin'");
    $stmt->execute();
    $adminRole = $stmt->fetch();
    
    if (!$adminRole) {
        // Create admin role if it doesn't exist
        $stmt = $pdo->prepare("INSERT INTO roles (name, description) VALUES (?, ?)");
        $stmt->execute(['Admin', 'System Administrator with full access']);
        $adminRoleId = $pdo->lastInsertId();
        echo "Created Admin role\n";
    } else {
        $adminRoleId = $adminRole['id'];
    }
    
    // Get all permissions
    $stmt = $pdo->query("SELECT id FROM permissions");
    $permissions = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    // Remove existing permissions for admin role
    $stmt = $pdo->prepare("DELETE FROM role_permissions WHERE role_id = ?");
    $stmt->execute([$adminRoleId]);
    
    // Add all permissions to admin role
    $stmt = $pdo->prepare("INSERT INTO role_permissions (role_id, permission_id) VALUES (?, ?)");
    foreach ($permissions as $permissionId) {
        $stmt->execute([$adminRoleId, $permissionId]);
    }
    
    echo "Successfully granted all permissions to Admin role\n";
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
} 